using System;
using Server.Network;
using Server.Misc;
using System.Collections;
using Server.Mobiles;

namespace Server.Misc
{
   public class MercenaryBlessTimer : Timer
   {
      private Mobile m_Mobile;

      public MercenaryBlessTimer( Mobile m, double t) : base( TimeSpan.FromSeconds( t ))
      {
         Priority = TimerPriority.OneSecond;
         m_Mobile = m;
         m.Blessed = true;
         m.Hits = 1;
         m.FixedParticles( 0x374A, 1, 15, 5054, 23, 7, EffectLayer.Head );
         if ( m.Female )
            m.PlaySound( Utility.RandomList( 336, 337 ) );
         else
            m.PlaySound( Utility.RandomList( 346, 347 ) );
         m.Emote( "*{0} umira*", m.Name );
         m.BodyMod = 0x3CA;
         m.HueMod = 0;
//          m.Say( "I'am granted one minute of immunity");
      }

      protected override void OnTick()
      {
         if ( m_Mobile.Blessed == false )
            Stop();
         else
         {
            m_Mobile.Blessed = false;
            m_Mobile.BodyMod = 0;
            m_Mobile.HueMod = -1;
            m_Mobile.FixedParticles( 0x373A, 10, 15, 5018, EffectLayer.Head );
            m_Mobile.PlaySound( 0x1EC );
            m_Mobile.Say( "Jsem {0} znovu bojovat!", ( m_Mobile.Female ) ? "pripravena" : "pripraven" );
            m_Mobile.PlaySound( ( m_Mobile.Female ) ? 779 : 1050 );
            Stop();
         }
      }
   }
}